/*
 * Decompiled with CFR 0.152.
 */
package sedonac.test;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Hashtable;
import sedona.Buf;
import sedona.dasp.DaspAcceptor;
import sedona.dasp.DaspException;
import sedona.dasp.DaspMessage;
import sedona.dasp.DaspSession;
import sedona.dasp.DaspSocket;
import sedona.dasp.DaspTestHooks;
import sedona.util.UserUtil;
import sedonac.test.Test;

public class DaspTest
extends Test {
    DaspSocket socket;
    DaspSession client;
    DaspSession server;
    String user;
    String pass;
    InetAddress local;
    TestHooks clientHooks;
    TestHooks serverHooks;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test() throws Exception {
        System.out.println();
        DaspTestHooks.runWhiteboxTests();
        System.out.println();
        this.local = InetAddress.getLocalHost();
        try {
            this.startServer(14);
            this.verifyConnect();
            this.verifyDatagrams();
            this.verifyClose();
            this.startServer(13);
            this.verifyConnect();
            this.verifyDatagrams();
            this.verifyClose();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.stopServer();
            throw throwable;
        }
        {
            Object var2_3 = null;
        }
        this.stopServer();
    }

    private final void verifyConnect() throws Exception {
        DaspException daspException = null;
        this.trace("Connect with bad username...");
        this.user = "bob";
        this.pass = "secret";
        daspException = null;
        try {
            this.socket.connect(this.local, this.socket.port(), "x", "y");
        }
        catch (DaspException daspException2) {
            daspException = daspException2;
        }
        this.verifyEq(daspException.errorCode, 228);
        this.trace("Connect with bad password...");
        daspException = null;
        try {
            this.socket.connect(this.local, this.socket.port(), "bob", "bad");
        }
        catch (DaspException daspException3) {
            daspException = daspException3;
        }
        this.verifyEq(daspException.errorCode, 228);
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("dasp.idealMax", "100");
        hashtable.put("dasp.absMax", "500");
        hashtable.put("dasp.receiveTimeout", "45000");
        hashtable.put("dasp.test", (Object)new TestHooks());
        this.trace("Connect...");
        this.client = this.socket.connect(this.local, this.socket.port(), "bob", "secret", hashtable);
        this.verify(this.client.isClosed() ^ true);
        boolean bl = false;
        if (this.client.id > 0 && this.client.id < (char)-1) {
            bl = true;
        }
        this.verify(bl);
        this.verifyEq(this.client.host, this.local);
        this.verifyEq(this.client.port, this.socket.port());
        this.server = this.socket.session(this.client.remoteId());
        boolean bl2 = false;
        if (this.server != null) {
            bl2 = true;
        }
        this.verify(bl2);
        this.verifyEq(this.server.remoteId(), this.client.id);
        this.verifyEq(this.server.host, this.local);
        this.verifyEq(this.server.port, this.socket.port());
        this.verifyEq(this.client.idealMax(), 100);
        this.verifyEq(this.client.absMax(), 500);
        this.verifyEq(this.client.localReceiveMax(), 31);
        this.verifyEq(this.client.remoteReceiveMax(), 31);
        this.verifyEq(this.client.receiveTimeout(), 45000L);
        this.verifyEq(this.server.idealMax(), 100);
        this.verifyEq(this.server.absMax(), 500);
        this.verifyEq(this.server.localReceiveMax(), 31);
        this.verifyEq(this.server.remoteReceiveMax(), 31);
        this.verifyEq(this.server.receiveTimeout(), 45000L);
    }

    private final void verifyDatagrams() throws Exception {
        int n = 0;
        while (n < 23) {
            byte[] byArray = ("msg " + n).getBytes("UTF-8");
            this.client.send(byArray);
            this.verifyEq(this.receive(100L), byArray);
            ++n;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        while (n2 < 23) {
            arrayList.add("msg " + n2);
            ++n2;
        }
        this.send(arrayList.toArray(new String[arrayList.size()]));
        while (arrayList.size() > 0) {
            byte[] byArray = this.receive(10000L);
            boolean bl = false;
            if (byArray != null) {
                bl = true;
            }
            this.verify(bl);
            String string = new String(byArray, "UTF-8");
            this.verify(arrayList.contains(string));
            arrayList.remove(string);
        }
        this.verify(true);
    }

    private final byte[] receive(long l) throws Exception {
        DaspMessage daspMessage = this.socket.queuingMode() == 14 ? this.server.receive(l) : this.socket.receive(l);
        boolean bl = false;
        if (daspMessage.session() == this.server) {
            bl = true;
        }
        this.verify(bl);
        return daspMessage.payload();
    }

    private final void send(final String[] stringArray) {
        Thread thread = new Thread("toSend async"){

            public final void run() {
                try {
                    TestHooks testHooks = (TestHooks)DaspTest.this.client.test;
                    int n = 0;
                    while (n < stringArray.length) {
                        if (n % 3 == 0) {
                            testHooks.addDrop(testHooks.sendSeqNum());
                        }
                        DaspTest.this.client.send(stringArray[n].getBytes("UTF-8"));
                        ++n;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    DaspTest.this.fail();
                }
            }
        };
        thread.start();
    }

    private final void verifyClose() throws Exception {
        this.trace("Close...");
        this.verify(this.client.isClosed() ^ true);
        this.verify(this.server.isClosed() ^ true);
        this.client.close();
        this.verify(this.client.isClosed());
        this.pause();
        this.verify(this.server.isClosed());
    }

    void startServer(int n) throws Exception {
        this.socket = DaspSocket.open((int)-1, (DaspAcceptor)new DaspAcceptor(){

            public final byte[] credentials(String string) {
                if (!string.equals(DaspTest.this.user)) {
                    return null;
                }
                return UserUtil.credentials((String)DaspTest.this.user, (String)DaspTest.this.pass);
            }

            public final Hashtable options() {
                Hashtable<String, TestHooks> hashtable = new Hashtable<String, TestHooks>();
                hashtable.put("dasp.test", new TestHooks());
                return hashtable;
            }
        }, (int)n);
        this.verifyEq(this.socket.isClosed(), false);
        this.verifyEq(this.socket.sessions().length, 0);
        this.verifyEq(this.socket.queuingMode(), n);
    }

    void stopServer() throws Exception {
        this.socket.close();
        this.verifyEq(this.socket.isClosed(), true);
        this.verifyEq(this.socket.sessions().length, 0);
        IllegalStateException illegalStateException = null;
        try {
            this.socket.connect(this.local, 99, "x", "y");
        }
        catch (IllegalStateException illegalStateException2) {
            illegalStateException = illegalStateException2;
        }
        this.verifyEq(illegalStateException.getMessage(), "socket is closed");
    }

    public void trace(String string) {
        System.out.println("[>] " + string);
    }

    public void pause() throws Exception {
        Thread.sleep(100L);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static class TestHooks
    extends DaspTestHooks {
        int dropType;
        int[] drop;

        public void clearDrop() {
            int n = 0;
            while (n < this.drop.length) {
                this.drop[n] = -1;
                ++n;
            }
        }

        public void addDrop(int n) {
            int n2 = 0;
            while (n2 < this.drop.length) {
                if (this.drop[n2] == -1) {
                    this.drop[n2] = n;
                    return;
                }
                ++n2;
            }
            throw new IllegalStateException("drop list full!");
        }

        public boolean receive(int n, int n2, byte[] byArray) {
            return true;
        }

        public boolean send(int n, int n2, byte[] byArray) {
            if (n == this.dropType) {
                System.out.println("  DROPPING msgType=" + n + ' ' + this.msgStr(byArray));
                this.dropType = -1;
                return false;
            }
            int n3 = 0;
            while (n3 < this.drop.length) {
                if (this.drop[n3] == n2) {
                    this.drop[n3] = -1;
                    System.out.println("  DROPPING " + n2 + ' ' + this.msgStr(byArray));
                    return false;
                }
                ++n3;
            }
            return true;
        }

        String msgStr(byte[] byArray) {
            try {
                Buf buf = new Buf(byArray);
                String string = "" + (char)buf.u1() + ' ' + buf.u1();
                if (buf.bytes[0] == 107) {
                    string = string + ' ' + buf.u2() + ' ' + buf.u2();
                }
                return string;
            }
            catch (Exception exception) {
                return "";
            }
        }

        private final /* synthetic */ void this() {
            this.dropType = -1;
            this.drop = new int[32];
        }

        TestHooks() {
            this.this();
            this.clearDrop();
        }
    }
}

